        '
        ' Horizontal scrolling example
        ' by Oscar Toledo G.
        ' https://nanochess.org/
        '

        DEFINE CHAR 128,51,image_char
        DEFINE COLOR 128,51,image_color

main_loop:
        CLS
        PRINT AT 33,"Scrolling example"

        PRINT AT 97,"1- Whole screen"
        PRINT AT 129,"2- Screen portion"

        DO
                WAIT
        LOOP WHILE cont.key = 15

        IF cont.key = 1 THEN GOSUB scrolling_whole
        IF cont.key = 2 THEN GOSUB scrolling_portion

        GOTO main_loop

scrolling_whole:        PROCEDURE
        CLS

        FOR d = 1 TO 10

        '
        ' Scrolling the whole screen, some tearing can happen
        ' because the VDP isn't so fast to move the whole screen
        ' in one frame.
        '
        FOR c = 0 TO 31
                WAIT
                WAIT
                SCREEN image_pattern,c,0,32-c,24,32
                IF c > 0 THEN
                        SCREEN image_pattern,0,32-c,c,24,32
                END IF
        NEXT c

        NEXT d
        
        END

        '
        ' Scrolling only part of the screen. No tearing happens.
        '
        CONST #VERT_START = 8 * 32
        CONST HEIGHT = 4

scrolling_portion:      PROCEDURE

        FOR d = 1 TO 10

        FOR c = 0 TO 31
                WAIT
                WAIT
                SCREEN image_pattern,c+#VERT_START,#VERT_START,32-c,HEIGHT,32
                IF c > 0 THEN
                        SCREEN image_pattern,0+#VERT_START,32-c+#VERT_START,c,HEIGHT,32
                END IF
        NEXT c
        NEXT d

        END

	' TMSColor 2.2.1 Mar/29/2024
	' Command: tmscolor -t128 -b -n scrolling.bmp scrolling.bas 
	' Created: Thu May 09 16:27:06 2024

	'
	' Recommended code:
	' MODE 0
	' DEFINE CHAR 128,51,image_char
	' DEFINE COLOR 128,51,image_color
	' SCREEN image_pattern,0,0,32,24,32
	'
image_char:
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$01,$01,$03,$03,$03,$01
	DATA BYTE $00,$7e,$ff,$c7,$c3,$e2,$f0,$f8
	DATA BYTE $00,$00,$00,$80,$00,$00,$00,$00
	DATA BYTE $00,$1e,$1e,$1e,$1e,$1e,$1e,$1e
	DATA BYTE $00,$78,$78,$78,$79,$79,$79,$79
	DATA BYTE $00,$00,$00,$00,$e0,$e0,$e0,$e0
	DATA BYTE $00,$00,$00,$00,$01,$01,$03,$07
	DATA BYTE $fe,$7f,$1f,$0f,$07,$87,$ff,$ff
	DATA BYTE $00,$03,$0f,$8f,$9e,$9e,$9e,$0f
	DATA BYTE $00,$e7,$f7,$27,$07,$07,$07,$27
	DATA BYTE $00,$98,$b9,$f9,$fb,$c3,$83,$81
	DATA BYTE $00,$7c,$ff,$ef,$c7,$c7,$c7,$ef
	DATA BYTE $1e,$1e,$1e,$1e,$9e,$9e,$9e,$1e
	DATA BYTE $78,$79,$79,$79,$79,$79,$79,$79
	DATA BYTE $00,$e7,$e7,$e7,$e7,$e7,$e7,$e7
	DATA BYTE $00,$bc,$fe,$9e,$9e,$9e,$9e,$9e
	DATA BYTE $00,$1e,$3f,$7d,$78,$78,$78,$7d
	DATA BYTE $00,$f0,$f0,$f0,$f0,$f0,$f0,$f0
	DATA BYTE $00,$00,$03,$07,$07,$07,$07,$07
	DATA BYTE $00,$f8,$fc,$8e,$8f,$ff,$80,$8c
	DATA BYTE $00,$3e,$1e,$0f,$0f,$07,$0f,$0e
	DATA BYTE $00,$f8,$f1,$e0,$c0,$c1,$c3,$e3
	DATA BYTE $00,$7e,$ff,$87,$f7,$ff,$c7,$c7
	DATA BYTE $00,$1e,$1f,$9f,$9e,$9e,$9e,$9e
	DATA BYTE $00,$79,$ff,$7c,$7c,$78,$78,$78
	DATA BYTE $00,$e3,$f3,$f3,$f3,$f3,$f3,$f3
	DATA BYTE $00,$de,$ff,$ef,$c7,$c7,$c7,$ef
	DATA BYTE $1e,$1e,$1e,$9e,$9e,$9e,$9e,$9e
	DATA BYTE $00,$0f,$3f,$78,$78,$7f,$78,$78
	DATA BYTE $00,$80,$c0,$e0,$f0,$f0,$00,$c0
	DATA BYTE $03,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $fe,$f8,$00,$00,$00,$00,$00,$00
	DATA BYTE $0f,$03,$00,$00,$00,$00,$00,$00
	DATA BYTE $f7,$e7,$00,$00,$00,$00,$00,$00
	DATA BYTE $81,$80,$00,$00,$00,$00,$00,$00
	DATA BYTE $ff,$7c,$00,$00,$00,$00,$00,$00
	DATA BYTE $1e,$1e,$00,$00,$00,$00,$00,$00
	DATA BYTE $79,$79,$00,$00,$00,$00,$00,$00
	DATA BYTE $e7,$e7,$00,$00,$00,$00,$00,$00
	DATA BYTE $9e,$9e,$00,$00,$00,$00,$00,$00
	DATA BYTE $3f,$1f,$00,$30,$3f,$7f,$00,$00
	DATA BYTE $f0,$f0,$f0,$f0,$e0,$c0,$00,$00
	DATA BYTE $1e,$3e,$00,$00,$00,$00,$00,$00
	DATA BYTE $f1,$f8,$00,$00,$00,$00,$00,$00
	DATA BYTE $ff,$f7,$00,$00,$00,$00,$00,$00
	DATA BYTE $7c,$7c,$00,$00,$00,$00,$00,$00
	DATA BYTE $f3,$f3,$03,$03,$03,$03,$00,$00
	DATA BYTE $ff,$de,$c0,$c0,$c0,$c0,$00,$00
	DATA BYTE $3f,$0f,$00,$00,$00,$00,$00,$00
	DATA BYTE $e0,$80,$00,$00,$00,$00,$00,$00

image_color:
	DATA BYTE $f1,$f1,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $f1,$f1,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$f1,$f1,$31,$f1,$f1,$f1,$f1
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$f1,$f1,$f1,$31,$31,$31,$31
	DATA BYTE $f1,$f1,$f1,$f1,$31,$31,$31,$31
	DATA BYTE $31,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $31,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $31,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$f1,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $31,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $f1,$31,$31,$31,$31,$31,$f1,$31
	DATA BYTE $31,$f1,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$31,$31,$31,$f1,$f1
	DATA BYTE $31,$31,$31,$31,$31,$31,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$31,$31,$31,$31,$f1,$f1
	DATA BYTE $31,$31,$31,$31,$31,$31,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1
	DATA BYTE $31,$31,$f1,$f1,$f1,$f1,$f1,$f1

image_pattern:
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$81,$82,$83,$80
	DATA BYTE $80,$80,$84,$85,$86,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$84,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$87,$88,$89,$8a
	DATA BYTE $8b,$8c,$8d,$8e,$8f,$90,$91,$92
	DATA BYTE $93,$94,$95,$96,$97,$98,$99,$9a
	DATA BYTE $9b,$9c,$9d,$9e,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$9f,$a0,$a1,$a2
	DATA BYTE $a3,$a4,$a5,$a6,$a7,$a8,$a9,$aa
	DATA BYTE $9f,$a0,$ab,$ac,$ad,$a8,$ae,$af
	DATA BYTE $b0,$a5,$b1,$b2,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
	DATA BYTE $80,$80,$80,$80,$80,$80,$80,$80
